#!/bin/bash
# $Id: delay.sh 13187 2014-05-26 22:40:05Z pwessel $
# Test gmt pstext with text clip delay

ps=delay.ps
FONT=24p,Helvetica

gmt pstext -R0/10/0/10 -JX15c/10c -F+f${FONT}+jCM -GC -B0 -B+glightbrown+t"Text below deliberately not plotted" -C0 -K -P << EOF > $ps
5 5 This text is plain but invisible
EOF

# Overlay big polygon
gmt psxy -R -J -L -Glightblue -W0.5p -O -K << EOF >> $ps
1 1
9 1
9 9
1 9
EOF

gmt psclip -C -O -K >> $ps

gmt pstext -R -J -F+f${FONT}+jCM -Gc -B0 -B+glightbrown -C0 -O -K -Y12c << EOF >> $ps
5 5 This text is plotted then clipped
EOF

# Overlay big polygon
gmt psxy -R -J -L -Glightblue -W0.5p -O -K << EOF >> $ps
1 1
9 1
9 9
1 9
EOF

gmt psclip -C -O >> $ps
