.TH GRDROTATER GMTMANSECTION "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
grdrotater \- Rotate a grid using a finite rotation
.SH SYNOPSIS
\fBgrdrotate\fP \fIingrdfile\fP \fB\-G\fP\fIoutgrdfile\fP \fB\-T\fP\fIplon\fP/\fIplat\fP/\fIomega\fP 
[ \fB\-F\fP\fIpolygonfile\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] 
[ \fB\-Q\fP[\fIvalue\fP] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-S\fP ] [ \fB\-V\fP ] 
[ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBgrdrotater\fP reads a geographical grid and reconstructs it given
a total reconstruction rotation.  Optionally, the user may supply a clipping polygon
in multiple-segment format; then, only the part of the grid inside the polygon is used
to determine the return grid region.  The outline of the projected region is returned
on stdout.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIingrdfile\fP
Name of a grid file in geographical (lon, lat) coordinates.
.TP
.B \-G
Name of output grid.  This is the grid with the data reconstructed according to the specified
rotation.
.TP
.B \-T
Finite rotation.  Specify the longitude and latitude of the rotation pole and the opening
angle, all in degrees.
.SH OPTIONS
.TP
.B \-F
Specify a multi-segment closed polygon file that describes the inside area of the grid
that should be projected [Default projects entire grid].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-M
Multiple segment file.  Segment separator is a record beginning with \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Do Not output the rotated polygon outline [Default will write it to stdout].
.TP
.B \-Q
Quick mode, use bilinear rather than bicubic interpolation [Default].  Optionally, append \fIvalue\fP in the
0 <= \fIvalue\fP <= 1 range.  This parameter controls how close to nodes with NaN values the
interpolation will go.  E.g., a \fIvalue\fP of 0.5 will interpolate about 1/2-way from a non-NaN to a
NaN node, whereas 0.1 will go about 90% of the way, etc. [Default is 1, which means none of the four nearby
nodes may be NaN].  A \fIvalue\fP of 0 will just return the value of the nearest node instead of interpolating.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
.B \-S
Skip the rotation of the grid, just rotate the polygon outline (requires \fB\-F\fP).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.SH EXAMPLES
To rotate the data defined by grid topo.grd and the polygon outline clip_path.d, using a finite rotation
with pole at (135.5, -33.0) and a rotation angle of 37.3 degrees and bicubic interpolation, try
.br
.sp
grdrotater topo.grd \fB\-T\fP135.5/-33/37.3 \fB\-V \-F\fPclip_path.d \fB\-G\fProt_topo.grd > rot_clip_path.d
.br
.sp
To rotate the entire grid faa.grd using a finite rotation pole at (67:45W, 22:35S) and a rotation angle of 19.6
degrees using a bilinear interpolation, try
.br
.sp
grdrotater faa.grd \fB\-T\fP67:45W/22:35S/19.6 \fB\-V \-Q \-G\fProt_faa.grd > rot_faa_path.d
.br
.sp
To just see how the outline of the grid large.grd will plot after the same rotation, try
.br
.sp
grdrotater large.grd \fB\-T\fP67:45W/22:35S/19.6 \fB\-V \-S\fP | psxy \fB\-Rg \-JH\fP180/6i \fB\-B\fP30 \fB\-M -W\fP0.5p | gv -
.br
.sp
Let say you have rotated gridA.grd and gridB.grd, restricting each rotation to nodes inside polygons polyA.d and polyB.d, respectively,
using rotation A = (123W,22S,16,4) and rotation B = (108W, 16S, -14.5), yielding rotated grids rot_gridA.grd and rot_gridB.grd.
To determine the region of overlap between the rotated grids, we use grdmath:
.br
.sp
grdmath 1 rot_gridA.grd ISNAN SUB 1 rot_gridB.grd ISNAN SUB 2 EQ = overlap.grd
.br
.sp
The grid overlap.grd now has 1s in the regions of overlap and 0 elsewhere.  You can use it as a mask
or use grdcontour to extract a polygon (contour).
.SH "SEE ALSO"
.IR backtracker (GMTMANSECTION),
.IR hotspotter (GMTMANSECTION),
.IR originator (GMTMANSECTION)
.IR rotconverter (GMTMANSECTION)
