.TH PSXY l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
psxy \- Plot lines, polygons, and symbols on maps
.SH SYNOPSIS
\fBpsxy\fP \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-A\fP ] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-D\fP\fIdx\fP/\fIdy\fP ] [ \fB\-E\fP[\fBx\fP|\fBy\fP|\fBX\fP|\fBY\fP][\fIcap\fP][/\fIpen\fP] ] 
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ] 
[ \fB\-N\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP[\fIsymbol\fP][\fIsize\fP] ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP[\fIpen\fP] ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpsxy\fP reads (\fIx\fP,\fIy\fP) pairs from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations on a map.
If a symbol is selected and no symbol size given, then \fBpsxy\fP will interpret the third column of the
input data as symbol size.  Symbols whose \fIsize\fP is <= 0 are skipped.  If no symbols are specified then the symbol code (see \fB\-S\fP below)
must be present as last column in the input.  Multiple segment files may be plotted using the \fB\-M\fP option.
If \fB\-S\fP is not selected, a line connecting the data points will be drawn instead.  To 
explicitly close polygons, use \fB\-L\fP.  Select a shade with \fB\-G\fP.  If \fB\-G\fP is set, \fB\-W\fP
will control whether the polygon outline is drawn or not.  If a symbol is selected, \fB\-G\fP and
\fB\-W\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output. 
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxy\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Suppress drawing line segments as great circle Arcs.  [Default draws great circle arcs].
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Give a color palette file.  When used with \fB\-S\fP, lets symbol fill color be determined by the z-value in the
third column.  Additional fields are
shifted over by one column (optional size would be 4th rather than 3rd field, etc.).
If \fB\-S\fP is not set, \fBpsxy\fP expects the user to supply a multisegment line or polygon file
(requires \fB\-M\fP) and will look for \fB\-Z\fP\fIval\fP strings in each multisegment header.  The \fIval\fP
will control the color of either the line or polygon (if \fB\-L\fP is set) via the cpt file.
.TP
.B \-D
Offset the plot symbol locations by the given amounts \fIdx/dy\fP [Default is no offset].  Only applies to symbols.
.TP
.B \-E
Draw error bars.  Append \fBx\fP and/or \fBy\fP to indicate which bars you want to draw (Default is both x and y).  The x and/or
y errors must be stored in the columns after the (x,y) pair [or (x,y,size) triplet].  The
\fIcap\fP parameter indicates the length of the end-cap on the error bars [0.25c (or 0.1i)].  Pen
attributes for error bars may also be set.  [Defaults: width = 1, color = black, texture = solid].  If upper case
\fBX\fP and/or \fBY\fP is used we will instead draw "box-and-whisker" (or "stem-and-leaf") symbols.  The x (or y)
coordinate is then taken as the median value, and 4 more columns are expected to contain the minimum (0% quartile), the 25%
quartile, the 75% quartile, and the maximum (100% quartile) values.  The 25-75% box may be filled by using \fB\-G\fP.
.TP
.B \-G
Select color for filling of symbols or select color or pattern for filling of polygons [Default is no fill].
.br
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.br
Note when \fB\-M\fP is chosen, \fBpsxy\fP will search for \fB\-G\fP and \fB\-W\fP
strings in all the subheaders and let any values thus found over-ride the command line settings.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Force closed polygons: connect the endpoints of the line-segment(s) and draw polygons.  Also, in
concert with \fB\-C\fP, \fB\-M\fP, and \fB\-Z\fP settings in the headers will use the implied
color for polygon fill [Default is polygon pen color].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Do NOT skip symbols that fall outside map border [Default plots points inside border only].  The
option does not apply to lines and polygons which are always clipped to the map region.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Plot symbols.  If present, size is symbol size in the
unit set in \.gmtdefaults4 (unless c, i, m, or p is
appended).  If the symbol code (see below) is not given
it will be read from the last column in the input data;
this cannot be used in conjunction with \fB\-b\fP.  Optionally, append
c, i, m, p to indicate that the size information in the
input data is in units of cm, inch, meter, or point,
respectively. [Default is \fBMEASURE_UNIT\fP].  Note: if you give both
size and symbol via the input file you must use \fBMEASURE_UNIT\fP to
indicate the units used for the symbol size.
.br
The uppercase symbols \fBA\fP, \fBC\fP, \fBD\fP, \fBG\fP, \fBH\fP, \fBI\fP, \fBN\fP, \fBS\fP, \fBT\fP are normalized
to have the same area as a circle with diameter \fIsize\fP, while
the corresponding lowercase symbols all are circumscribed
by the circle.  Choose between these symbol codes:
.TP
.B \-S-
x-dash.  \fIsize\fP is the length of a short horizontal line segment.
.TP
.B \-Sa
st\fBa\fPr.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sb
\fBb\fPar extending from \fIbase\fP to y.  \fIsize\fP is bar width. Append \fBu\fP
if \fIsize\fP is in x-units [Default is plot-distance units]. By default,
\fIbase\fP = 0.  Append \fBb\fP\fIbase\fP to change this value.  
.TP
.B \-Sc
\fBc\fPircle.  \fIsize\fP is diameter of circle.
.TP
.B \-Sd
\fBd\fPiamond.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Se
\fBe\fPllipse.  Direction (in degrees counter-clockwise from horizontal), major_axis, and minor_axis must be found in columns 3, 4, and 5.
.TP
.B \-SE
Same as \fB\-Se\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Se\fP leaves the directions
unchanged.)  Furthermore, the axes lengths must be given in km instead of plot-distance units.  An exception occurs for
a linear projection in which we assume the ellipse axes are given in the same units as \fB\-R\fP.
.TP
.B \-Sf
\fBf\fPront.  \fB\-Sf\fP\fIgap/size\fP[\fIdir\fP][\fItype\fP][:\fIoffset\fP].  Supply distance gap between symbols and symbol size.
If \fIgap\fP is negative, it is interpreted to mean the number of symbols along the front instead.  Append \fIdir\fP to plot symbols
on the \fBl\fPeft or \fBr\fPight side of the front [Default is centered].  Append \fItype\fP to specify which symbol
to plot: \fBb\fPox, \fBc\fPircle, \fBf\fPault, \fBs\fPlip, or \fBt\fPriangle.  [Default is fault].
Slip means left-lateral or right-lateral strike-slip arrows (centered is not an option).  Append :\fIoffset\fP to offset
the first symbol from the beginning of the front by that amount [Default is 0].
.TP
.B \-Sh
\fBh\fPexagon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Si
\fBi\fPnverted triangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sj
Rotated rectangle.  Direction (in degrees counter-clockwise from horizontal), x-dimension, and y-dimension must be found in columns 3, 4, and 5.
.TP
.B \-SJ
Same as \fB\-Sj\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sj\fP leaves the directions
unchanged.)  Furthermore, the dimensions must be given in km instead of plot-distance units.  An exception occurs for
a linear projection in which we assume the dimensions are given in the same units as \fB\-R\fP.
.TP
.B \-Sk
\fBk\fPustom symbol.  Append <name>/\fIsize\fP, and we will look for a definition file called
<name>.def in (1) the current directory or (2) in ~/.gmt or (3) in \fB$GMTHOME\fP/share/custom.  The symbol as defined
in that file is of size 1.0 by default; the appended \fIsize\fP will scale symbol accordingly.
Users may add their own custom *.def files; see CUSTOM SYMBOLS below.
.TP
.B \-Sl
\fBl\fPetter or text string (less than 64 characters).  Give size, and append /\fIstring\fP after the size.  Note that
the size is only approximate; no individual scaling
is done for different characters.  Remember to escape special characters like *.  Optionally, you may append %\fIfont\fP
to select a particular font [Default is \fBANNOT_FONT_PRIMARY\fP].
.TP
.B \-Sg
octa\fBg\fPon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sn
pe\fBn\fPtagon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sp
\fBp\fPoint.  No size needs to be specified (1 pixel is used).
.TP
.B \-Sq
\fBq\fPuoted line, i.e., lines with annotations such as contours.  Append [\fBd|f|n|l|x\fP]\fIinfo\fP[:\fIlabelinfo\fP].
The required argument controls the placement of labels along the quoted lines.
Choose among five controlling algorithms:
.RS
.TP
\fBd\fP\fIdist\fP[c|i|m|p] or \fBD\fP\fIdist\fP[d|e|k|m|n]
For lower case \fBd\fP, give distances between labels on the plot in your preferred measurement unit
\fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points), while for upper case \fBD\fP, specify
distances in map units and append the unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP
(nautical mile), or \fBd\fP (spherical degree).  [Default is 10\fBc\fP or 4\fBi\fP].  
.TP
\fBf\fP\fIffile.d\fP
Reads the ascii file \fIffile.d\fP and places labels at locations in the file
that matches locations along the quoted lines.
Inexact mathces and points outside the region are skipped.
.TP
\fBl|L\fP\fIline1\fP[,\fIline2\fP,...]
Give \fIstart\fP and \fIstop\fP coordinates for one or
more comma-separated straight line segments.  Labels will be placed where these lines intersect the
quoted lines.  The format of each \fIline\fP specification is \fIstart/stop\fP, where \fIstart\fP and \fIstop\fP
are either a specified point \fIlon/lat\fP or a 2-character \fBXY\fP key that uses the justification
format employed in \fBpstext\fP to indicate a point on the map, given as [LCR][BMT].
\fBL\fP will interpret the point pairs as defining great circles [Default is straight line].
.TP
\fBn\fP\fIn_label\fP
Specifies the number of equidistant labels for quoted lines line [1].
Upper case \fBN\fP starts labeling exactly at the start of the line [Default centers them along the line].
\fBN\fP-1 places one justified label at start, while \fBN\fP+1 places one justified
label at the end of quoted lines.
Optionally, append /\fImin_dist\fP[c|i|m|p] to enforce that a minimum distance separation
between successive labels is enforced.
.TP
\fBx|X\fP\fIxfile.d\fP
Reads the multi-segment file \fIxfile.d\fP and places labels at the intersections
between the quoted lines and the lines in\fIxfile.d\fP.  \fBX\fP will resample the lines first along
great-circle arcs.
.RE
.sp
.RS
The optional \fIlabelinfo\fP controls the specifics of the label formatting and consists of a concatenated string
made up of any of the following control arguments:
.RE
.RS
.TP
\fB+a\fP\fIangle\fP
For annotations at a fixed angle, \fB+an\fP for line-normal, or \fB+ap\fP for line-parallel [Default].
.TP
\fB+c\fP\fIdx\fP[/\fIdy\fP]
Sets the clearance between label and optional text box.  Append \fBc|i|m|p\fP to specify
the unit or % to indicate a percentage of the label font size [15%].
.TP
\fB+f\fP\fIfont\fP
Sets the desired font [Default \fBANNOT_FONT_PRIMARY\fP].
.TP
\fB+g\fP[\fIcolor\fP]
Selects opaque text boxes [Default is transparent]; optionally specify the color [Default is \fBPAGE_COLOR\fP].
.TP
\fB+j\fP\fIjust\fP
Sets label justification [Default is CM].
.TP
\fB+k\fP\fIcolor\fP
Sets color of text labels [Default is \fBCOLOR_BACKGROUND\fP].
.TP
\fB+l\fP\fIlabel\fP
Sets the constant label text.
.TP
\fB+L\fP\fIflag\fP
Sets the label text according to the specified flag:
.RS
.TP
\fB+Lh\fP
Take the label from the current multisegment header (first scan for an embedded
\fB\-L\fP\fIlabel\fP option, if not use the first word following the segment flag).
.TP
\fB+Ld\fP
Take the Cartesian plot distances along the line as the label; append \fBc|i|m|p\fP
as the unit [Default is \fBMEASURE_UNIT\fP].
.TP
\fB+LD\fP
Calculate actual map distances; append \fBd|e|k|m|n\fP as the unit [Default is \fBd\fP(egrees),
unless label placement was based on map distances along the lines in which case we use the same unit specified for that algorithm].
Requires a map projection to be used.
.TP
\fB+Lf\fP
Use text after the 2nd column in the fixed label location file as the label.  Requires the fixed label
location setting.
.TP
\fB+Lx\fP
As \fB+Lh\fP but use the headers in the \fIxfile.d\fP instead.  Requires the crossing file option.
.RE
.TP
\fB+o\fP
Selects rounded rectangular text box [Default is rectangular].  Not applicable for curved text (\fB+v\fP) and
only makes sense for opaque text boxes.
.TP
\fB+p\fP[\fIpen\fP]
Draws the outline of text boxsets [Default is no outline]; optionally specify pen for outline [Default is width = 0.25p, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
\fB+r\fP\fImin_rad\fP
Will not place labels where the line's radius of curvature is less than \fImin_rad\fP [Default is 0].\"'
.TP
\fB+s\fP\fIsize\fP
Sets the desired font size in points [Default is 9].
.TP
\fB+u\fP\fIunit\fP
Appends \fIunit\fP to all line labels. If \fIunit\fP starts with a leading hypen (-) then there will be no space
between label value and the unit.
[Default is no unit].
.TP
\fB+v\fP
Specifies curved labels following the path [Default is straight labels].
.TP
\fB+w\fP
Specifies how many (\fIx, y\fP) points will be used to estimate label angles [Default is 10].
.TP
\fB+=\fP\fIprefix\fP
Prepends \fIprefix\fP to all line labels.
If \fIprefix\fP starts with a leading hypen (-) then there will be no space
between label value and the prefix. [Default is no prefix].
.RE
.TP
.B \-Sr
\fBr\fPectangle.  No size needs to be specified, but the x- and y-dimensions must be found in columns 3 and 4.
.TP
.B \-Ss
\fBs\fPquare.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-St
\fBt\fPriangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sv
\fBv\fPector.  Direction (in degrees counter-clockwise from horizontal) and length must be found in columns 3 and 4.  \fIsize\fP,
if present, will be interpreted as arrowwidth/headlength/headwidth [Default is 0.075\fBc\fP/0.3\fBc\fP/0.25\fBc\fP (or 0.03\fBi\fP/0.12\fBi\fP/0.1\fBi\fP)].
By default arrow attributes remains invariant to the length
of the arrow.  To have the size of the vector scale down with decreasing size,
append \fBn\fP\fInorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP.  To center vector on balance point, use \fB\-Svb\fP; to align point with the vector head,
use \fB\-Svh\fP; to align point with the vector tail, use \fB\-Svt\fP [Default].  To give the head point's coordinates\"'
instead of direction and length, use \fB\-Svs\fP.  Upper case \fBB, H, T, S\fP will draw a double-headed vector [Default is single head].
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sw
pie \fBw\fPedge.  Start and stop directions (in degrees counter-clockwise from horizontal) for pie slice
must be found in columns 3 and 4.
.TP
.B \-SW
Same as \fB\-Sw\fP, except azimuths (in degrees east of north) should be given instead of the two directions.  The azimuths will
be mapped into angles based on the chosen map projection (\fB\-Sw\fP leaves the directions unchanged.)
.TP
.B \-Sx
cross.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sy
y-dash.  \fIsize\fP is the length of a short vertical line segment.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes for lines or the outline of symbols.  [Defaults: width = 1, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is the required number of columns given the chosen settings].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To plot solid red circles (diameter = 0.25 cm) at the positions listed in the file DSDP.xy on a
Mercator map at 5 cm/degree of the area 150E to 154E, 18N to 23N, with tickmarks every 1 degree
and gridlines every 15 minutes, use
.br
.sp
\fBpsxy\fP DSDP.xy \fB\-R\fP150/154/18/23 \fB\-Jm\fP5\fBc \-Sc\fP0.25\fBc\fP \fB\-G\fPred \fB\-B\fP1\fBg\fP15\fBm\fP | lpr
.br
.sp
To plot the xyz values in the file quakes.xyzm as circles with size given by the magnitude in the
4th column and color based on the depth in the third using the color palette cpt on a linear map, use
.br
.sp
\fBpsxy\fP quakes.xyzm \fB\-R\fP0/1000/0/1000 \fB\-JX\fP6\fBi\fP \fB\-Sc\fP \fB\-C\fPcpt \fB\-B\fP200 > map.ps
.br
.sp
To plot the file trench.xy on a Mercator map, with white triangles with sides 0.25 inch on the left
side of the line, spaced every 0.8 inch, use
.br
.sp
\fBpsxy\fP trench.xy \fB\-R\fP150/200/20/50 \fB\-Jm\fP0.15\fBi \-Sf\fP0.8\fBi\fP/0.1\fBilt\fP \fB\-G\fPwhite \fB\-W \-B\fP10 | lpr
br
.sp
To plot the data in the file misc.d as symbols determined by the code in the last column, and with size given
by the magnitude in the 4th column, and color based on the third column via the color palette cpt on a linear map, use
.br
.sp
\fBpsxy\fP misc.d \fB\-R\fP0/100/-50/100 \fB\-JX\fP6\fBi\fP \fB\-S\fP \fB\-C\fPcpt \fB\-B\fP20 > t.ps
.SH BUGS
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.br
\fBpsxy\fP cannot handle filling of polygons that contain the south or north pole.  For such a polygon,
make a copy and split it into two and make each explicitly contain the polar point.  The two polygons
will combine to give the desired effect when filled; to draw outline use the original polygon.
.SH CUSTOM SYMBOLS
\fBpsxy\fP and \fBpsxyz\fP allows users to define and plot their own custom symbols.
This is done by encoding the symbol using a simple plotting code described below.  Put
all the plotting codes for your new symbol in a file whose extension must be .def; you may then address
the symbol without giving the extension (e.g., the symbol file tsunami.def is used by specifying \fB\-Sk\fP\fItsunami/size\fP.
The definition file can contain any number of plot code records, as well as blank lines and comment lines (starting with #).
\fBpsxy\fP and \fBpsxyz\fP will look for the definition files in (1) the current directory, (2) the ~/.gmt
directory, and (3) the \fB$GMTHOME\fP/share/custom directory, in that order.
Freeform polygons (made up of straight line segments and arcs of circles) can be designed - these polygons can be
painted and filled with a pattern.  Other standard geometric symbols can also be used.  With the exception of the circle,
these can only be painted, not filled with a pattern (use the freeform polygons to include a triangle that can be filled
with a pattern).  Generate freeform polygons by starting with an anchor point (append [ \fB\-W\fP\fIpen\fP ] and [ \fB\-G\fP\fIfill\fP ]
to indicate pen and fill attributes):
.br
	\fIx0	y0\fP	\fBM\fP
.br
and draw a straight line from the current point to the next point with
.br
	\fIx	y\fP	\fBD\fP
.br
or add an arc by using
.br
	\fIxc	yc	r	dir1	dir2\fP	\fBA\fP
.br
When a record other than the \fBD\fP or \fBA\fP is encountered, the polygon is closed and considered complete.
The optional pen and fill setting hardwires particular values for this feature.  If not present the polygon's\"'
characteristics are determined by the command line settings for pen and fill.  To deactivate fill or outline
for any given polygon, give \fB\-G\-\fP or \fB\-W\-\fP.  To add other geometric shapes
to your custom symbol, add any number of the following plot code records (each accepts the optional
[ \fB\-W\fP\fIpen\fP ] and [ \fB\-G\fP\fIfill\fP ] at the end):
.br
.sp
star:	\fIx	y	size\fP	\fBa\fP
.br
circle:	\fIx	y	size\fP	\fBc\fP
.br
cross:	\fIx	y	size\fP	\fBx\fP
.br
diamond:	\fIx	y	size\fP	\fBd\fP
.br
ellipse:	\fIx	y	dir	major	minor\fP	\fBe\fP
.br
hexagon:	\fIx	y	size\fP	\fBh\fP
.br
invtriangle:	\fIx	y	size\fP	\fBi\fP
.br
letter:	\fIx	y	size	string\fP	\fBl\fP
.br
octagon:	\fIx	y	size\fP	\fBg\fP
.br
pentagon:	\fIx	y	size\fP	\fBn\fP
.br
rect:	\fIx	y	xwidth	ywidth\fP	\fBr\fP
.br
square:	\fIx	y	size\fP	\fBs\fP
.br
triangle:	\fIx	y	size\fP	\fBt\fP
.br
wedge:	\fIx	y	radius	dir1	dir2\fP	\fBw\fP
.br
.sp
When designing your symbol, the \fIx, y\fP and other dimensions are relative to a symbol of size 1, and all the
dimensions will be scaled by the actual symbol size chosen at run-time.  To design a symbol, make a grid paper
with \fBpsbasemap \-R\fP-0.5/0.5/-0.5/0.5 \fB\-JX\fP4\fBi\fP \fB\-Ba\fP0.1\gBg\gP0.05 \fB\-P\fP > grid.ps and
draw your symbol, centering it on (0,0).  For examples of symbols, see the set supplied with \fBGMT\fP in \fB$GMTHOME\fP/share/custom.
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l),
.IR psxyz (l)
