.TH GRDFILTER l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
grdfilter \- Filter a 2-D gridded file in the space (or time) domain
.SH SYNOPSIS
\fBgrdfilter\fP \fIinput_file.grd\fP \fB\-D\fP\fIdistance_flag\fP \fB\-F\fP\fI<filtertype><width>\fP[\fImode\fP] 
\fB\-G\fP\fIoutput_file.grd\fP [ \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-T\fP ] [ \fB\-V\fP ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdfilter\fP will filter a \fI.grd\fP file in the time domain using one
of the selected convolution or non-convolution filters and
compute distances using Cartesian or Spherical geometries.
The output \fI.grd\fP file can optionally be generated as a
sub\fB\-R\fPegion of the input and/or with a new \fB\-I\fPncrement.  In this
way, one may have "extra space" in the input data so that the
edges will not be used and the output can be within one-half-
width of the input edges.  If the filter is low-pass, then the
output may be less frequently sampled than the input.
.TP
\fIinput_file.grd\fP
The file of points to be filtered.
.TP
.B \-D
Distance \fIflag\fP tells how grid (x,y) relates to filter \fIwidth\fP as follows:
.sp
\fIflag\fP = 0:  grid (x,y) same units as \fIwidth\fP, Cartesian distances.
.br
\fIflag\fP = 1:  grid (x,y) in degrees, \fIwidth\fP in kilometers, Cartesian distances.
.br
\fIflag\fP = 2:  grid (x,y) in degrees, \fIwidth\fP in km, dx scaled by cos(middle y), Cartesian distances.
.sp
The above options are fastest because they allow weight matrix to be computed only once.
The next two options are slower because they recompute weights for each latitude.
.sp
\fIflag\fP = 3:  grid (x,y) in degrees, \fIwidth\fP in km, dx scaled by cosine(y), Cartesian distance calculation.
.br
\fIflag\fP = 4:  grid (x,y) in degrees, \fIwidth\fP in km, Spherical distance calculation.
.TP
.B \-F
Sets the filter type.  Choose among convolution and non-convolution filters.  Append the filter code followed
by the full diameter \fIwidth\fP. Available convolution filters are:
.br
(\fBb\fP) Boxcar: All weights are equal.
.br
(\fBc\fP) Cosine Arch: Weights follow a cosine arch curve.
.br
(\fBg\fP) Gaussian: Weights are given by the Gaussian function.
.br
Non-convolution filters are:
.br
(\fBm\fP) Median: Returns median value.
.br
(\fBp\fP) Maximum likelihood probability (a mode estimator): Return modal value.
If more than one mode is found we return their average value.  Append - or + to
the filter width if you rather want to return the smallest or largest of the modal
values.
.br
(\fBl\fP) Lower: Return the minimum of all values.
.br
(\fBL\fP) Lower: Return minimum of all positive values only.
.br
(\fBu\fP) Upper: Return maximum of all values.
.br
(\fBU\fP) Upper: Return maximum or all negative values only.
.br
In the case of \fBL|U\fP it is possible that no data passes the initial sign test; in that case
the filter will return 0.0.
.TP
.B \-G
\fIoutput_file.grd\fP is the output of the filter.
.SH OPTIONS
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the output Increment. Append \fBm\fP to indicate minutes, or \fBc\fP to indicate seconds.
If  the new \fIx_inc, y_inc\fP are NOT integer multiples of the old ones (in the input data), filtering will be considerably slower.
[Default:  Same as input.]
.TP
.B \-R
\fIwest, east, south, \fPand \fInorth\fP defines the Region of the output points.  [Default:  Same as input.]
.TP
.B \-T
Toggle the node registration for the output grid so as to become the opposite of the input grid
[Default gives the same registration as the input grid].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
Suppose that north_pacific_dbdb5.grd is a file of 5 minute bathymetry from 140E to 260E and 0N to 50N, and you want to find
the medians of values within a 300km radius (600km full width) of the output points, which you choose to be from 150E to 250E
and 10N to 40N, and you want the output values every 0.5 degree.  Using spherical distance calculations, you need:
.sp
\fBgrdfilter\fP north_pacific_dbdb5.grd \fB\-G\fPfiltered_pacific.grd \fB\-Fm\fP600 \fB\-D\fP4 \fB\-R\fP150/250/10/40 \fB\-I\fP0.5 \fB\-V\fP
.SH LIMITATIONS
When working with geographic (lat, lon) grids, all three convolution filters (boxcar, cosine arch, and gaussian) will properly normalize
the filter weights for the variation in gridbox size with latitude, and correctly determine which nodes are needed for the convolution
when the fiter "circle" crosses a periodic (0-360) boundary or contains a geographic pole.  However, the spatial filters, such as median and mode filters,
do not use weights and thus should only be used on Cartesian grids (or at very low latitudes) only.  If you want to apply such spatial
filters you should project your data to an equal-area projection and run grdfilter on the resulting Cartesian grid.
.SH "SEE ALSO"
.IR GMT (l),
.IR grdfft (l)
