.TH GMTLEGS l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
gmtlegs \- Find cruises in a given region
.SH SYNOPSIS
\fBgmtlegs\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-G\fP ] [ \fB\-M\fP ] [ \fB\-T\fP ] [ \fB\-L\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgmtlegs\fP will report the name of all the cruises that happened to be wholly or partially inside the
specified region. As an option, only those cruises that collected a certain type of data can be
reported.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-G
Report cruises that collected Gravity data. [Default is any data].
.TP
.B \-M
Report cruises that collected Magnetics. [Default is any data].
.TP
.B \-T
Report cruises that collected Topography. [Default is any data].
.TP
.B \-L
Long output, i.e. cruisenames and data types available. [Default is cruisenames only].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To find all cruises around Hawaii that collected gravity and topography:
.br
.sp
\fBgmtlegs\fP \fB\-R\fR-162/-152/18/25 \fB\-G \-T\fP > hawaii_gt.legs
.br
.sp
To find all cruises with magnetics:
.br
.sp
\fBgmtlegs\fP \fB\-R\fR0/360/-90/90 \fB\-M\fP > all_m.legs
.SH "SEE ALSO"
.IR GMT (l),
.IR gmt2bin (l),
.IR binlegs (l)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
