.TH BACKTRACKER l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
backtracker \- Forward and Backward flowlines and hotspot tracks 
.SH SYNOPSIS
\fBbacktracker\fP [\fIinfile(s)\fP] \fB\-E\fP\fIstage_file\fP 
[ \fB\-A\fP[\fIyoung\fP/\fIold\fP] ] [ \fB\-C\fP ] [ \fB\-Df\fP|\fBb\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] 
[ \fB\-Lf\fP|\fBb\fP\fIstep\fP ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] [ \fB\-N\fP\fIupper_age\fP ] 
[ \fB\-Q\fP\fIfixed_age\fP ] [ \fB\-S\fP\fIfilestem\fP ] [ \fB\-T\fP\fIzero_age\fP ] [ \fB\-V\fP ] 
[ \fB\-W\fP[\fBa\fP|\fBt\fP] ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBbacktracker\fP reads (longitude, latitude, age) positions from \fIinfiles\fP 
[or standard input] and computes projected (x,y,t) coordinates using the 
specified rotation parameters.  It can either calculate final
positions [Default] or create a sampled track between the initial and final
positions.  The former mode allows additional data fields after the first 3
columns which must have (longitude,latitude,age).
See option \fB\-:\fP on how to read (latitude,longitude,age) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfile(s)\fP
Data file(s) to be projected.  If not given, standard input is read.
.TP
.B \-E
Give file with rotation poles and opening angles.  This file must contain
one record for each rotation; each record must be of the following format:
.br
.sp
	lon lat tstart [tstop] ccw-angle [k a b c d e f g]
.br
.sp
where tstart [and tstop] are in Ma, with lon, lat, and angle in degrees.  For
stage rotations, the oldest stage
must be listed first, whereas for total reconstruction rotations the youngest
rotation is listed first.  tstart (tstop) is the age of the old (young) end of the
stage.  A covariance matrix, if present, may be given in the given format.
Blank lines and records whose first column contains # will be ignored.
.SH OPTIONS
.TP
.B \-A
Used in conjunction with \fB\-Lb|f\fP to limit the track output to those sections
whose predicted ages fit between the \fIyoung\fP and \fIold\fP limits.  If \fB\-LB|F\fP
is used instead then the limits apply to the stage ids.  If no limits are supplied
then individual limits for each seamount are expected in columns 4 and 5 of the input file.
.TP
.B \-C
Expect Total Reconstruction Poles (Finite Poles) rather than Backward Stage Poles [Default].
File format is similar to the stage pole format except the youngest rotation must be listed
first and that the tstart column is optional (assumed to be 0 Ma).
.TP
.B \-D
Set the direction to go: \fB\-Df\fP will go forward in time (from younger to older positions), while
\fB\-Db\fP will go backward in time (from older to younger positions) [Default].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-L
Specify a sampled path between initial and final position: \fB\-Lf\fP will
draw flowlines, while \fB\-Lb\fP will draw backtrack (hotspot track) paths.
Append sampling interval in km.  If \fIstep\fP < 0 then only the bend-times (knots)
will be returned.  When \fB\-LF\fP or \fB\-LB\fP is used, the
third output column will contain the stage id (1 is youngest) [Default is
along-track ages].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Set the maximum age to extend the oldest stage back in time [Default is no extension].
.TP
.B \-Q
Assign a fixed age to all positions.  Only lon, lat input is expected.
.TP
.B \-S
When \fB\-L\fP is set, the tracks are normally written to stdout as a multisegment
file.  Specify a \fIfilestem\fP to have each track written to \fIfilestem.#\fP, where
\fI#\fP is the track number.  The track number is also copied to the 4th output column.
.TP
.B \-T
Set the current time [Default is 0 Ma].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Rotates the given input (lon,lat,t) and calculates the confidence ellipse for the
projected point.  The input point \fImust\fP have a time coordinate that matches
a particular finite rotation time, otherwise the point will be skipped.  Append
\fBt\fP or \fBa\fP to output time or angle, respectively, after the projected
lon, lat.  After these 2-3 items, we write azimuth, major, minor (in km) for the
95% confidence ellipse.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default depends on settings].
.SH EXAMPLES
To backtrack the (x,y,t) points in the file seamounts.d to their origin
(presumably the hotspot), using the DC85.d Euler poles, run
.br
.sp
\fBbacktracker\fP seamounts.d \fB\-Db \-E\fPDC85.d > newpos.d
.br
.sp
To project flowlines forward from the (x,y,t) points stored in several 3-column,
binary, double precision files, run
.br
.sp
\fBbacktracker\fP points.* \fB\-Df \-E\fPDC85.d \fB\-Lf\fP25 \fB\-bo \-bi\fP\fI3\fP > lines.b
.br
.sp
This file can then be plotted with \fBpsxy \-M\fP.
.SH "SEE ALSO"
.IR GMT (l),
.IR project (l),
.IR mapproject (l),
.IR hotspotter (l),
.IR originator (l)
.SH REFERENCES
Wessel, P., 1999, "Hotspotting" tools released, EOS Trans. AGU, 80 (29), p. 319.
.br
