.TH PSSEGY GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
pssegy \- Create imagemasked postscript from SEGY file
.SH SYNOPSIS
\fBpssegy\fP \fISEGYfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP \fB\-D\fP\fIdeviation
\fB\-F\fP[\fBrgb|gray\fP]|\fB\-W\fP
[ \fB\-B\fP\fIbias\fP ] [ \fB\-C\fP\fIclip\fP ] [ \fB-E\fP\fIerror\fP ] [ \fB\-I\fP ]
[ \fB\-K\fP ] [ \fB\-L\fP\fInsamp\fP ] [ \fB\-M\fP\fIntrace\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ]
[ \fB\-P\fP ] [ \fB\-S\fP\fIheader\fP ] [ \fB-T\fP\fIfilename\fP ] [ \fB\-U\fP\fIredvel\fP ]
[ \fB\-V \fP ] [ \fB\-X\fP\fIscale\fP ] [ \fB\-Y\fP\fIsample int\fP ] [ \fB\-Z\fP ]
.SH DESCRIPTION
\fBpssegy\fP reads a native (IEEE) format SEGY file and produces a
\fIPostScript\fP image of the seismic data. The \fIimagemask\fP
operator is used so that the seismic data are plotted as a 1-bit
deep bitmap in a single
(user-specified) color or gray shade, with a transparent background.
The bitmap resolution is taken from the current \fBGMT\fP defaults.
The seismic traces may be plotted at their true locations using information
in the trace headers (in which case order of the
traces in the file is not significant).
 Standard \fBGMT\fP geometry routines are used so that
in principle any map projection may be used, however it is likely that the
geographic projections will lead to unexpected results. Beware also
that some parameters have non-standard meanings.
Note that the order of operations before the seismic data are plotted is
deviation*[clip]([bias]+[normalize](sample value)). Deviation determines
how far \fIin the plot coordinates\fP a [normalized][biased][clipped] sample
value of 1 plots from the trace location.
The SEGY file should be a disk image of the tape format (ie 3200 byte
text header, which is ignored, 400 byte binary reel header, and
240 byte header for each trace) with samples as native real*4 (IEEE real
on all the platforms to which I have access)
.TP
\fISEGYfile\fP
Seismic data set to be imaged
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.br
.TP
.B \-D
gives the deviation in X units of the plot for 1.0 on the scaled trace.
.br
.TP
.B \-F[\fIrgb\fP|\fIgray\fP]
Fill trace (variable area, defaults to filling positive). rgb or gray gives
the color with which the imagemask is filled.
.TP
.B \-W
Draw wiggle trace.
.TP
\fI Must specify at least one of -W and -F.\fP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Bias to apply to data (added to sample values).
.TP
.B \-C
Sample value at which to clip data (clipping is applied to both positive and
negative values).
.TP
.B \-E
Allow \fIerror\fP difference between requested and actual trace locations
when using \fB-T\fP option.
.TP
.B \-I
Fill negative rather than positive excursions.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Override number of samples per trace in reel header (program attempts to
determine number of samples from each trace header if possible to
allow for variable length traces).
.TP
.B \-M
Override number of traces specified in reel header. Program detects
end of file (relatively) gracefully, but this parameter limits number
of traces that the program attempts to read.
.TP
.B \-N
Normalize trace by dividing by rms amplitude over full trace length.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Read trace locations from trace headers: header is either c for CDP,
o for offset, or b<num> to read a long starting at byte <num> in the
header (first byte corresponds to num=0). Default has location given by
trace number.
.TP
.B \-T
Plot only traces whose location corresponds to a list given in \fIfilename\fP.
Order in which traces are listed is not significant - the entire space is
checked for each trace.
.TP
.B \-U
Apply reduction velocity by shifting traces \fIupwards\fP by redvel/|offset|.
Negative velocity removes existing reduction. Units should be consistent with
offset in trace header and sample interval.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X
Multiply trace locations by scale before plotting.
.TP
.B \-Y
Override sample interval in reel header.
.TP
.B \-Z
Do not plot traces with zero rms amplitude.
.SH EXAMPLES
To plot the SEGY file wa1.segy with normalized traces plotted at true offset
locations, clipped at +-3 and with wiggle trace and positive variable area
shading in black, use
.br
.sp
\fBpssegy\fP wa1.segy \fB\-JX\fP5/\-5 \fB\-R\fP0/100/0/10 \fB\-D\fP1 \fB\-C\fP3 \fB\-N\fP \fB\-S\fPo \fB\-W\fP \fB\-F\fP0 > segy.ps
.br
.sp
To plot the SEGY file wa1.segy with traces plotted at true cdp*0.1, clipped
at +-3, with bias -1 and negative variable area shaded red, use
.br
.sp
\fBpssegy\fP wa1.segy \fB\-JX\fP5/\-5 \fB\-R\fP0/100/0/10 \fB\-D\fP1 \fB\-C\fP3 \fB\-S\fPc \fB\-X\fP0.1 \fB\-F\fP255/0/0 \fB\-B\fP\-1 \fB\-I\fP > segy.ps
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR pssegyz (GMTMANSECTION)
