.TH PSPOLAR GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
\fBpspolar\fR\ - Plot polarities on the inferior focal half\-sphere on maps
.SH SYNOPSIS
.br
pspolar \fIfiles \fB\-J\fIparameters \fB\-R\fIwest/east/south/north\fR
\fB\-D\fIlongitude/latitude\fR \fB\-M\fIsize\fR \fB\-S\fI<symbol><size>\fR
[ \fB\-B\fItickinfo\fR ] [ \fB\-C\fIlongitude/latitude\fR[/dash_width/pointsize\fR] ]
[ \fB\-F\fIred/green/blue\fR ] [ \fB\-G\fIfill\fR ] [ \fB\-g\fIfill\fR ]
[ \fB\-H\fR ] [ \fB\-h\fR ] [ \fB\-K\fR ] [ \fB\-L\fR ] [ \fB\-N\fR ]
[ \fB\-O\fR ] [ \fB\-P\fR ]
[ \fB\-s\fR\fIHalf-size\fB[v[\fI[<v_width/h_length/h_width/shape>]\fB][g\fI[<r/g/b>]\fB][l\fB]
[ \fB-T\fIangle/form/justify/fontsize\fR ] [ \fB-t\fI<pen>\fR ]
[ \fB\-U\fI[label]\fR ] [ \fB\-V\fR ] [ \fB\-W\fIpen\fR ]
[ \fB\-X\fIx-shift\fR ] [ \fB\-Y\fIy-shift\fR ] [ \fB\-c\fIcopies\fR ]
.SH DESCRIPTION
.br
\fBpspolar\fR reads data values from \fIfiles\fR [or standard input]
and generates \fIPostScript\fR code that will plot stations on focal mechanisms
on a map.
The \fIPostScript\fR code is written to standard output.
.br
.sp
Parameters are expected to be in the following columns
.TP
.B 1,2,3,4
station_code, azimuth, take-off angle, polarity
.br
.sp
polarity:
.br
- compression can be c,C,u,U,+
.br
- rarefaction can be d,D,r,R,-
.br
- not defined is anything else
.br
.sp
.SH ARGUMENTS
\fIfiles\fR
List one or more file-names. If no files are given, pspolar will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
\fB\-D\fIlongitude/latitude\fR
Maps the bubble at given longitude and latitude point.
.br
.TP
\fB\-M\fIsize\fR
Sets the size of the beach ball to plot polarities in. \fISize\fR is in inch
(unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
.br
.TP
\fB\-S\fI<symbol_type><size>\fR
Selects \fIsymbol_type\fR and symbol \fIsize\fR.
Size is in inch (unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
Choose symbol type from
st(\fIa\fR)r, (\fIc\fR)ircle, (\fId\fR)iamond, (\fIh\fR)exagon,
(\fIi\fR)nverted triangle, (\fIp\fR)oint, (\fIs\fR)quare, (\fIt\fR)riangle,
(\fIx\fR)cross.
.br
.LP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
\fB\-C\fR
Offsets focal mechanisms to the latitude and longitude specified in the last
two columns of the input file.
.br
.TP
\fB\-E\fIfill\fR
\fRSelects filling of symbols for stations in extensive quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 250/250/250].
If \fB-E\fIfill\fR is the same as \fB-F\fIfill\fR, use \fB-e\fR to outline.
.br
.TP
\fB\-e\fI[pen]\fR
Outline symbols in extensive quadrants using \fIpen\fR or the default pen (see
\fB\-W\fR).
.br
.TP
\fB\-F\fR\fIfill\fR
Sets background color of the beach ball. Default is no fill.
.br
.TP
\fB\-f\fI[pen]\fR
Outline the beach ball using \fIpen\fR or the default pen (see \fB\-W\fR).
.br
.TP
\fB\-G\fR\fIfill\fR
Selects filling of symbols for stations in compressional quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 0/0/0].
.br
.TP
\fB\-g\fI[pen]\fR
Outline symbols in compressional quadrants using \fIpen\fR or the default pen
(see \fB\-W\fR).
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
\fB\-h\fP
Use special format derived from HYPO71 output
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
\fB\-s\fIhalf\-size/[V[<v_width/h_length/h_width/shape>]][G<r/g/b>][L]
.br
Plots S polarity azimuth.
.br
S polarity is in last column.
It may be a vector (V option) or a segment.
Give half\-size,v_width,h_length,h_width in inch
(unless \fBc\fR, \fBi\fR, \fBm\fR, or \fBp\fR is appended).
[L] option is for outline.
.br
.TP
\fB\-T\fIangle/form/justify/fontsize in points\fP
.br
To write station code. [Default is 0.0/0/5/12].
.br
.TP
\fB\-t\fI<pen>
Set pen color to write station code. Default uses the default pen (see
\fB\-W\fR).
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
\fB\-W\fR
Set current pen attributes
 [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.br
.SH EXAMPLES
.sp
\fBpspolar\fP \fB\-R\fP239/240/34/35.2 \fB\-JM\fP8 \fB\-N\fP \fB\-Sc\fP0.4 \fB\-H\fP1 \fB\-D\fP239.5/34.5 \fB\-M\fP5 <<END>! test.ps
.br
stat azim ih pol
.br
0481 11 147 c
.br
6185 247 120 d
.br
0485 288 114 +
.br
0490 223 112 -
.br
0487 212 109 .
.br
END
.br
or
.br
\fBpspolar\fP \fB\-R\fP239/240/34/35.2 \fB\-JM\fP8 \fB\-N\fP \fB\-Sc\fP0.4 \fB\-H\fP1 \fB\-D\fP239.5/34.5 \fB\-M\fP5 \fB\-h\fP <<END>! test.ps
.br
Date Or. time stat azim ih
.br
910223 1 22 0481 11 147 ipu0
.br
910223 1 22 6185 247 120 ipd0
.br
910223 1 22 0485 288 114 epu0
.br
910223 1 22 0490 223 112 epd0
.br
910223 1 22 0487 212 109 epu0
.br
END
.br
.sp
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION),
.IR psxy (GMTMANSECTION)
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.SH AUTHORS
\fRGenevieve Patau
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@ipgp.jussieu.fr)
.br
