.TH MGD77TRACK l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
mgd77track \- A shiptrack plotting program
.SH SYNOPSIS
\fBmgd77track\fP \fIleg-ids\fP \fB\-R\fIwest/east/south/north\fP \fB\-J\fP\fIparameters\fP
[ \fB\-A\fP[\fBc\fP][\fIsize\fP] ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-Da\fP\fIstartdate\fP ] [ \fB\-Db\fP\fIstopdate\fP ]
[ \fB\-K\fP ] [ \fB\-M\fP\fItrackticks\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Sa\fP\fIstartdist\fP ]
[ \fB\-Sb\fP\fIstopdist\fP ] [ \fB\-TT|t|d\fP\fIms,mc,mfs,mf,mfc\fP ] [ \fB\-U\fP[\fIdx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V \fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBmgd77track\fP reads NGDC MGD-77 cruises and creates \fIPostScript\fP code that will plot one or more ship tracks on a
map using the specified projection. The \fIPostScript\fP code is written to standard output.
.TP
\fIleg-ids\fP
Can be one or more NGDC names, like 01010007 etc.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Annotate each leg every time it enters the plot. Append \fBc\fP to annotate using the MGD77 cruise ID [Default
uses the filename prefix]. Optional \fIsize\fP is the font size in points.
The leg annotation font is controlled by \fBLABEL_FONT\fP.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-Da
Do not plot data collected before \fIstartdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]) [Default is first day].
.TP
.B \-Db
Do not plot data collected after \fIstopdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]). [Default is last day].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
To put time/distance Marks on the track. E.g. \fBa\fP500\fBka\fP24\fBht\fP6\fBh\fP means (\fBa\fP)nnotate
every 500 km (\fBk\fP) and 24 \fBh\fP(ours), with (\fBt\fP)ickmarks every 500 km and 6 hours.
Alternatively you may use the modifiers \fBd\fP (days) and \fBn\fP (nautical miles).
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Sa
Do not plot data that are less than \fIstartdist\fP km along track from port of departure. Append
k for km, m for miles, or n for nautical miles [Default is 0 meters].
.TP
.B \-Sb
Do not plot data that are more than \fIstopdist\fP km along track from port of departure. Append
k for km, m for miles, or n for nautical miles [Default is length of track].
.TP
.B \-T
Controlls the attributes of the three kinds of markers (\fBT\fP for the first time marker in a new
day, \fBt\fP for additional time markers in the same day, and \fBd\fP for distance markers). For each
of these you can specify the 5 comma-separated attributes \fImarkersize\fP, \fImarkercolor\fP,
\fImarkerfontsize\fP, \fImarkerfont\fP, and \fImarkerconfcolor\fP. Repeat the \fB\-T\fP option for
each marker type.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-W
\fIpen\fP is the pne used for the trackline. [Default is 0.25p,black].
[Default is solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To generate a Mercator plot of the track of the cruise 01010007 in the area 70W to
20E, 40S to 20N, using a Mercator scale of 0.1inch/degree, label the tracks with 10 points characters, annotate
the boundaries every 10 degrees, draw gridlines every 5 degrees, and mark the track every day and 1000 km,
with ticks every 6 hours and 250 km, and send the plot to the default printer,
enter the following command:
.br
.sp
\fBmgd77track\fP 01010007 \fB\-R\fP70W/20E/40S/20N \fB\-Jm\fP0.1 \fB\-B\fP10\fBg\fP5 \fB\-A\fP10 \fB\-M\fPa1da1000kf6hf250k | lpr
.SH "SEE ALSO"
.IR mgd77info (l),
.IR psbasemap (l)
.IR mgd77list (l)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
4 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http:
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
