.TH MGD77INFO l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
mgd77info \- Get information about MGD77 files
.SH SYNOPSIS
\fBmgd77info\fP \fIleg-ids\fP \fB\-I\fP|\fBL\fP [ \fB\-V\fP ]
.SH DESCRIPTION
\fBmgd77info\fP reads <legid>.mgd77 files and produces a single record of information
about each cruise specified. The information includes beginning and end time, total
track distance in km, min and max regional extent, and the total number of geophysical
observations. Optionally, choose instead to see the original MGD77 header section.
.br
If you need to know which tracks are crossing through a given region and what kinds
of geogphysical observations are available, consider using the x2sys tools to set up
a tracks index data base.
.TP
\fIleg-ids\fP
Can be one or more MGD77 8-character cruise identifiers. To give a list of names, use `cat cruises.lis`.
The ".mgd77" extension will automatically be appended, if needed. Cruise files will be looked for
in the current directory and in all directories listed in \fB$MGD77_DIR\fP/MGD77_paths.txt.
.TP
.B \-I
Give a one-line summary for each cruise listed, OR
.TP
.B \-L
Give the long MGD77 header section for each cruise listed.
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To get one-line summary information about the cruises 01010047.mgd77 and 01010008.mgd77, try
.br
.sp
\fBmgd77info\fP 01010047 01010008 \fB\-I\fP > listing.lis
.br
.sp
To see the MGD77 header for cruise 01010047.mgd77, run
.br
.sp
\fBmgd77info\fP 01010047 \fB\-L\fP
.SH "SEE ALSO"
.IR mgd77list (l),
.IR mgd77track (l)
.IR x2sys_init (l)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
4 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http:
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
