.TH GRDVIEW l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdview \- Create 3-D perspective grayshaded/colored image or mesh from a 2-D grd file
.SH SYNOPSIS
\fBgrdview\fP \fIrelief_file\fP \fB\-J\fP\fIparameters\fP
[ \fB\-B\fP\fItickinfo\fP ] [\fB\-C\fP\fIcptfile\fP] [ \fB\-E\fP\fIview_az/view_el\fP ]
[ \fB\-G\fP\fIdrapefile\fP | \fB\-G\fP\fIgrd_r\fP,\fIgrd_g\fP,\fIgrd_b\fP ] [ \fB\-I\fP\fIintensfile\fP] [ \fB\-K\fP ]
[ \fB\-L\fP[\fIflags\fP] ] [ \fB\-N\fP\fIlevel\fP[/\fIr/g/b\fP]] [ \fB\-O\fP ] [ \fB\-P\fP ]
[ \fB\-Q\fP\fItype\fP[\fBg\fP] ] [ \fB\-R\fP\fIwest/east/south/north/zmin/zmax\fP[\fBr\fP] ] [ \fB\-S\fP\fIsmooth\fP ]
[ \fB\-T\fP[\fBs\fP][\fBo\fP[\fIpen\fP]] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP\fItype/pen\fP ] [ \fB\-X\fP\fIx-shift\fP ]
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBgrdview\fP reads a 2-D gridded file and produces a 3-D perspective plot by
drawing a mesh, painting a colored/grayshaded surface made up of polygons, or by scanline conversion of these polygons
to a rasterimage. Options include draping a data set on top of a surface, plotting of contours on top of the
surface, and apply artificial illumination based on intensities provided in a separate grd file.
.TP
\fIrelief_file\fP
2-D gridded data set to be imaged (the relief of the surface).
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps). Same syntax as \fB\-Jx\fP.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
name of the color palette file. Must be present if you want (1) mesh plot with
contours (\fB\-Qm\fP), or (2) shaded/colored perspective image (\fB\-Qs\fP or \fB\-Qi\fP).
For \fB\-Qs\fP: You can specify that you want to skip a z-slice by setting red = -; to
use a pattern give red = \fBP|p\fP\fIdpi/pattern\fP[:\fBF\fP\fIr/g/b\fP[\fBB\fP\fIr/g/b\fP]].
.TP
.B \-E
Sets the view point by specifying azimuth and elevation in degrees. [Default is 180/90].
.TP
.B \-G
Drape the image in \fIdrapefile\fP on top of the relief provided by \fIrelief_file\fP. [Default is \fIrelief_file\fP].
Note that \fB\-Jz\fP and \fB\-N\fP always refers to the \fIrelief_file\fP. The \fIdrapefile\fP only provides
the information pertaining to colors, which is looked-up via the cpt file (see \fB\-C\fP). Alternatively, give
three gridfiles separated by commas. These files must contain the red, green, and blue colors directly (in 0-255 range)
and no cpt file is needed. The \fIdrapefile\fP may be of higher resolution than the \fIrelief_file\fP.
.TP
.B \-I
Gives the name of a grdfile with intensities in the (-1,+1) range. [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Boundary condition \fIflags\fP may be \fIx\fP or \fIy\fP or \fIxy\fP indicating data is periodic in range of
x or y or both, or \fIflags\fP may be \fIg\fP indicating geographical conditions (x and y are
lon and lat). [Default uses "natural" conditions (second partial derivative normal to edge is zero).]
If no \fIflags\fP are set, use bilinear rather than the default bicubic resampling when draping is required.
.TP
.B \-N
Draws a plane at this z-level. If the optional r/g/b is provided, the frontal facade between
the plane and the data perimeter is colored.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Select one of four settings: 1. Specify \fBm\fP for mesh plot [Default], and optionally append /r/g/b for a different mesh paint [white].
2. Specify \fBs\fP for surface plot, and optionally append \fBm\fP to have mesh lines drawn on top of surface.
3. Specify \fBi\fP for image plot, and optionally append the effective dpi resolution for the rasterization [100].
4. Specify \fBc\fP. Same as \fB\-Qi\fP but will mask out nodes with z = NaN using the colormasking feature in \fIPostScript\fP Level 3
(the PS device must support PS Level 3).
For any of these choices, you may force a monochrome image by appending \fBg\fP. Colors are then
converted to shades of gray using the (television) YIQ transformation.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
This option may be used to indicate the range used for the 3-D axes [Default is
region given by the \fIrelief_file\fP]. You may ask for a larger
\fIw/e/s/n\fP region to have more room between the image and the axes. A smaller region
than specified in the \fIrelief_file\fP will result in a subset of the grid.
.TP
.B \-S
Smooth the contours before plotting (see \fBgrdcontour\fP) [Default is no smoothing].
.TP
.B \-T
Plot image without any interpolation. This involves converting each node-centered
bin into a polygon which is then painted separately. Append \fBs\fP to skip
nodes with z = NaN. This option is useful for categorical data where
interpolating between values is meaningless. Optionally, append \fBo\fP to
draw the tile outlines, and specify a custom pen if the default pen is not to
your liking.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Wc
Draw contour lines on top of surface or mesh (not image). Append pen attributes used for the contours.
[Default: width = 3, color = 0/0/0, texture = solid].
.TP
.B \-Wm
Sets the pen attributes used for the mesh. [Default: width = 1, color = 0/0/0, texture = solid].
You must also select \fB\-Qm\fP or \fB\-Qsm\fP for meshlines to be drawn.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-Z
Sets the z-level of the basemap [0].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To make a mesh plot from the file hawaii_grav.grd and drawing the contours
given in the color palette file hawaii.cpt on a Lambert map
at 1.5 cm/degree along the standard parallels 18 and 24, with vertical scale 20 mgal/cm, and
looking at the surface from SW at 30 degree elevation, run
.br
.sp
\fBgrdview\fP hawaii_grav.grd \fB\-Jl\fP18/24/1.5\fBc\fP \fB\-C\fPhawaii.cpt \fB\-Jz\fP0.05\fBc\fP \fB\-Qm \-N\fP-100 \fB\-E\fP225/30 \fB\-Wc\fP > hawaii_grav_image.ps
.br
.sp
To create a illuminated color perspective plot of the gridded data set image.grd, using the color
palette file color.rgb, with linear scaling at 10 cm/x-unit
and tickmarks every 5 units, with intensities provided by the file intens.grd, and looking from the SE, use
.br
.sp
\fBgrdview\fP image.grd \fB\-Jx\fP10.0\fBc\fP \fB\-C\fPcolor.rgb \fB\-Qs \-E\fP135/30 \fB\-I\fPintens.grd > image3D.ps
.br
.sp
To make the same plot using the rastering option with dpi = 50, use
.br
.sp
\fBgrdview\fP image.grd \fB\-Jx\fP10.0\fBc\fP \fB\-C\fPcolor.rgb \fB\-Qi\fP50 \fB\-E\fP135/30 \fB\-I\fPintens.grd > image3D.ps
.br
.sp
To create a color \fIPostScript\fP perspective plot of the gridded data set magnetics.grd, using the color
palette file mag_intens.cpt, draped over the relief given by the file topography.grd, with Mercator map width of 6 inch
and tickmarks every 1 degree, with intensities provided by the file topo_intens.grd, and looking from the SE, run
.br
.sp
\fBgrdview\fP topography.grd \fB\-JM\fP6\fBi\fP \fB\-G\fPmagnetics.grd \fB\-C\fPmag_intens.cpt \fB\-Qs \-E\fP140/30 \fB\-I\fPtopo_intens.grd > draped3D.ps
.br
.sp
Given topo.grd and the Landsat image veggies.ras, first run \fBgmt2rgb\fP to get the red, green, and blue grids, and then drape
this image over the topography and shade the result for good measure. The commands are
.br
.sp
\fBgmt2rgb\fP veggies.ras \fB\-G\fPlayer_%c.grd
.br
\fBgrdview\fP topo.grd \fB\-JM\fP6\fBi\fP \fB\-Qi \-E\fP140/30 \fB\-I\fPtopo_intens.grd \fB\-G\fPlayer_r.grd,layer_g.grd,layer_b.grd > image.ps
.SH BUGS
For the \fB\-Qs\fP option: \fIPostScript\fP provides no way of smoothly varying colors within a polygon, so colors can only
vary from polygon to polygon. To obtain smooth images this way you may resample the grdfile(s) using \fBgrdsample\fP or
use a finer grid size when running gridding programs like \fBsurface\fP or \fBnearneighbor\fP. Unfortunately,
this produces huge \fIPostScript\fP files. The alternative is to use the \fB\-Qi\fP option, which
computes bilinear or bicubic continuous color variations within polygons by using scanline conversion to image the polygons.
.SH "SEE ALSO"
.IR gmt (l),
.IR gmt2rgb (l),
.IR grdcontour (l),
.IR grdimage (l),
.IR nearneighbor (l),
.IR psbasemap (l),
.IR pscontour (l),
.IR pstext (l),
.IR surface (l)
