.TH GMTLIST l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
gmtlist \- A data-extractor for <legid>.gmt files
.SH SYNOPSIS
\fBgmtlist\fP \fIleg-ids\fP [ \fB\-C\fP\fIcorrectionfile\fP ] [ \fB\-Da\fP\fIstartdate\fP ]
[ \fB\-Db\fP\fIstopdate\fP ] [ \fB\-F\fP\fIflags\fP ] [ \fB\-G\fP ] [ \fB\-H\fP ] [ \fB\-R\fIwest/east/south/north\fP ]
[ \fB\-Sa\fP\fIstartdist\fP ] [ \fB\-Sb\fP\fIstopdist\fP ] [ \fB\-V\fP ] [ \fB\-W\fP\fIweight\fP ] [ \fB\-b\fP ]
.SH DESCRIPTION
\fBgmtlist\fP reads <legid>.gmt files and produces an ASCII [or binary] table. The <legid>.gmt files
contain time(\fBs\fP), latitude(\fBy\fP), longitude(\fBx\fP), gravity(\fBg/G\fP),
magnetics(\fBm/M\fP), and bathymetry(\fBt/T\fP),
and the user may extract any combination of these 6 parameters + distance(\fBd\fP),
heading (\fBh\fP), velocity (\fBv\fP), and weight (\fBw\fP, see \fB\-W\fP). A sub-section can be
specified by passing time- or distance-intervals along track or by selecting a region.
.TP
\fIleg-ids\fP
Can be one or more cruisenames. To give a list of names, use `cat list_of_legs`.
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-C
Apply crossover Corrections to the data. If no correction file is given, gmtlist reads the
default correction file. (See \fBXSYSTEM\fP for how to set up your own correction file).
.TP
.B \-Da
Do not list data collected before \fIstartdate\fP (mm/dd/yyyy/hh:mm) [Default is first day].
.TP
.B \-Db
Do not list data collected after \fIstopdate\fP (mm/dd/yyyy/hh:mm). [Default is last day].
.TP
.B \-F
Can be any combination of \fBsyxgmtdhv\fP to indicate the desired output data. The data will
appear in the order indicated by flags. If \fBGMT\fP is substituted for \fBgmt\fP, only records that
have that combination of data are written out. If \fBs\fP is followed by \fBc\fP (calendar),
then yyyy/mm/dd/hh/mm/ss is written out, if \fBs\fP is
followed by \fBj\fP (julian), then yyyy/jd/hh/mm/ss is written out. Default is seconds from start
of year.
.TP
.B \-G
Force Geographical longitudes (-180/+180) rather than geodetic (0-360) [Default].
.TP
.B \-H
Issue a header record with names for each data field.
.TP
.B \-Sa
Do not list data that are less than \fIstartdist\fP km along track from port of departure. [Default is 0].
.TP
.B \-Sb
Do not list data that are more than \fIstopdist\fP km along track from port of departure. [Default is length of track].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set the weight for these data. Weight output option must be set in \fB\-F\fP. This is
useful if the data are to be processed with the weighted averaging techniques offered by
\fBblockmean\fP, \fBblockmedian\fP, and \fBblockmode\fP.
.TP
.B \-b
Selects binary output mode (in double precision) [Default is ASCII]. \fB\-H\fP is ignored if \fB\-b\fP is selected.
Julian and calendar dates are not supported for binary time output (i.e., you get seconds from start of year).
.SH EXAMPLES
To get a (distance, heading, crossover-corrected gravity, bathymetry) listing from c2104.gmt,
starting at June 3 1971 20:45 and ending at distance = 5000 km, use the following command:
.br
.sp
\fBgmtlist\fP c2104 \fB\-Da\fP6/3/1971/20:45 \fB\-Sb\fP5000 \fB\-F\fPdhgt \fB\-C\fP > myfile
.br
.sp
To make input for \fBblockmean\fP and \fBsurface\fP using all the cruises listed in the file gmt.list,
but only the data that are inside the specified area, and make output binary:
.br
.sp
\fBgmtlist\fP `cat gmt.list` \fB\-F\fPxyg \fB\-R\fP-40/-30/25/35 \fB\-b\fP > allgrav.xyg
.SH "SEE ALSO"
.IR gmt (l),
.IR xsystem (l)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
4 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http:
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
