.TH BACKTRACKER GMTMANSECTION DATE VERSION VERSION
.SH NAME
backtracker \- Forward and Backward flowlines and hotspot tracks 
.SH SYNOPSIS
\fBbacktracker\fP [\fIinfile(s)\fP] \fB\-E\fP\fIstage_file\fP 
[ \fB\-A\fP[\fIyoung/old\fP] ] [ \fB\-C\fP ] [ \fB\-Df|b\fP ] [ \fB\-H\fP[\fInrec\fP] ] 
[ \fB\-Lf|t\fP\fIstep\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fIupper_age\fP ] 
[ \fB\-S\fP\fIfilestem\fP ] [ \fB\-T\fP\fIzero_age\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ] 
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBbacktracker\fP reads (longitude, latitude, age) positions from \fIinfiles\fP 
[or standard input] and computes projected (x,y,t) coordinates using the 
specified stage pole (Euler) rotations.  You can either calculate just final
positions [Default] or create a sampled track between initial and final
position.  The former mode allows additional data fields after the first 3
columns which must have (longitude,latitude,age).
See option \fB\-:\fP on how to read (latitude,longitude,age) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfile(s)\fP
Data file(s) to be projected.  If not given, standard input is read.
.TP
.B \-E
Give file with stage poles and opening angles.  This file must contain
one record for each stage; each record must be of the following format:
.br
.sp
	lon lat tstart tstop ccw-angle
.br
.sp
where time is in Ma and the rest is in degrees.  Oldest stage must be
listed first.  tstart is the time when the stage begins (oldest age).
Blank lines and records whose first column contains # will be ignored.
.SH OPTIONS
.TP
.B \-A
Used in conjunction with \fB\-Lb|f\fP to limit the track output to those sections
whose predicted ages fit between the \fIyoung\fP and \fIold\fP limits.  If \fB\-LB|F\fP
is used instead then the limits apply to the stage ids.  If no limits are supplied
then individual limits for each seamount are expected in the input file's columns 4 and 5.
.TP
.B \-C
Expect Total Reconstruction Poles (Finite Poles) rather than Backward Stage Poles [Default]
File format is similar to the stage pole format except the youngest rotation must be listed
first and that the tstart column is optional (assumed to be 0 Ma).
.TP
.B \-D
Set the direction to go: \fB\-Df\fP will go forward in time, while
\fB\-Db\fP will go backward in time [Default].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-L
Specify a sampled path between initial and final position: \fB\-Lf\fP will
draw flowlines, while \fB\-Lb\fP will draw backtrack (hotspot track) paths.
Append sampling interval in km.  When \fB\-LF\fP or \fB\-LB\fP is used, the
third output column will contain the stage id (1 is youngest) [Default is
along-track ages].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN.
.TP
.B \-N
Set the maximum age to extend the oldest stage back in time [Default is no extension].
.TP
.B \-S
When \fP\-L\fP is set, the tracks are normally written to stdout as a multisegment
file.  Specify a \fIfilestem\fP to have each track written to \fIfilestem.#\fP, where
\fI#\fP is the track number.  The track number is also copied to the 4th output column.
.TP
.B \-T
Set the current time [Default is 0 Ma].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
Applies to geographic coordinates only.
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 3 input columns].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.SH EXAMPLES
To backtrack the (x,y,t) points in the file seamounts.d to their origin
(presumably the hotspot), using the DC85.d Euler poles, run
.br
.sp
backtracker seamounts.d \fB\-Db \-E\fPDC85.d > newpos.d
.br
.sp
To project flowlines forward from the (x,y,t) points stored in several 3-column,
binary, double precision files, run
.br
.sp
backtracker points.* \fB\-Df \-E\fPDC85.d \fB\-Lf\fP25 \fB\-bo \-bi\fP\fI3\fP > lines.b
.br
.sp
This file can then be plotted with psxy \fB\-M\fP.
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR project (GMTMANSECTION),
.IR mapproject (GMTMANSECTION),
.IR hotspotter (GMTMANSECTION)
.IR originator (GMTMANSECTION)
.SH REFERENCES
Wessel, P., 1999, "Hotspotting" tools released, EOS Trans. AGU, 80 (29), p. 319.
.br
